set matsize 11000
clear all
set more off
 
local path C:\Users\wb615937\OneDrive - WBG\Desktop\Gender_Eicher et al_FINAL\Gender_Eicher et al_June25\Replication_Gender_Feb20\Original_Data_Construction
cd "`path'"

////////////////////////////////////////////////////////////////////
//////////////////////// TRADING ECONOMICS ////////////////////////
////////////////////////////////////////////////////////////////////

import excel "`path'\Total Reserves In Months Of Imports.xlsx", sheet("Sheet1") firstrow clear
gen year = year(Date)
replace Country = "Yemen Arab Republic" if  Country == "Yemen" 
replace Country = "Saint Vincent and the Grenadines" if  Country == "St Vincent and the Grenadines" 
replace Country = "Saint Lucia" if  Country == "St Lucia" 
replace Country = "Slovak Republic" if  Country == "Slovakia" 
replace Country = "965" if  Country == "Serbia" 
replace Country = "Democratic Republic of Congo" if  Country == "Congo" 
replace Country = "Congo" if  Country == "Republic Of The Congo" 
replace Country = "Macao" if  Country == "Macau" 
replace Country = "Kyrgyz Republic" if  Country == "Kyrgyzstan" 
replace Country = "Cote d'Ivoire" if  Country == "Ivory Coast" 
replace Country = "Guinea-Bissau" if  Country == "Guinea Bissau" 
replace Country = "Timor" if  Country == "East Timor" 
merge m:m Country using for_mapping.dta
replace countrycode = 733 if Country == "South Sudan"
replace Country_code = "SSD" if Country == "South Sudan"
replace countrycode = 967 if Country == "Kosovo"
replace Country_code = "UVK" if Country == "Kosovo"

drop if _m ==2
drop if _m ==1 & !inlist(Country, "South Sudan", "Kosovo")
drop _m
replace   Country = "Serbia" if  Country == "965"
drop  Date Country_code Country
rename Value TradeEcon_MoRes
save TradingEconomics_Cleaned, replace

/*
tab Country if _m==1

                         Country |      Freq.     Percent        Cum.
---------------------------------+-----------------------------------
                         Curacao |          6        1.21        1.21
                      East Timor |         18        3.62        4.83
                  European Union |         49        9.86       14.69 OK
                   Guinea Bissau |         25        5.03       19.72
                     Ivory Coast |          9        1.81       21.53
                          Kosovo |         20        4.02       25.55
                      Kyrgyzstan |         30        6.04       31.59
                           Macau |         21        4.23       35.81
                       Palestine |         18        3.62       39.44
           Republic Of The Congo |         42        8.45       47.89
                          Serbia |         17        3.42       51.31
                        Slovakia |         31        6.24       57.55
                      South Asia |         49        9.86       67.40 OK
                     South Sudan |          7        1.41       68.81
                        St Lucia |         48        9.66       78.47
   St Vincent and the Grenadines |         46        9.26       87.73
                           World |         49        9.86       97.59 OK
                           Yemen |         12        2.41      100.00
---------------------------------+-----------------------------------
                           Total |        497      100.00

*/
						   

////////////////////////////////////////////////////////////////////
////////////Months of Reserves - Missing was Filled Here////////////
////////////////////////////////////////////////////////////////////

import excel "`path'\Total Reserves in Months of Imports (Oct 2024).xlsx", sheet("Data") firstrow clear
drop IndicatorCode IndicatorName Latest Year
kountry CountryCode , from(iso3c) to (imfn)
rename _IMFN_ countrycode
replace countrycode = 171 if CountryName =="Andorra"
replace countrycode = 967 if CountryName =="Kosovo"
replace countrycode = 359 if CountryName =="Puerto Rico"
replace countrycode = 733 if CountryName =="South Sudan"
replace countrycode = 869 if CountryName =="Tuvalu"
replace countrycode = 487 if CountryName =="West Bank and Gaza"
drop if countrycode ==.
reshape long year, i(countrycode) j(time)
rename year MoRes_Fill
rename time year
drop CountryName
save MoRes_Full, replace

////////////////////////////////////////////////////////////////////
/////*IMF Project Clean the Gender Index Data to Ready to Merge/////
////////////////////////////////////////////////////////////////////

import delimited "`path'\IMF GENDER_EQUALITY_INDEX 09-05-2023 17-22-05-44_timeSeries 17-22-05-44_timeSeries.csv", varnames(1) clear 

local oldprefix "v"
local newprefix "year"
local startyear 1990

forval i = 6/29 {
    local oldvar `oldprefix'`i'
    local newvar `newprefix'`startyear'
    local oldlabel : variable label `oldvar'
    rename `oldvar' `newvar'
    label variable `newvar' "`oldlabel'"
    local startyear = `startyear' + 1
}

drop v30

keep if indicatorcode == "GE_GII"

reshape long year, i(countrycode) j(time)
rename year genindex
rename time year

save genderindex, replace


////////////////////////////////////////////////////////////////////
/////*Clean the Format of Loaded WB Dataset through R to Merge//////
////////////////////////////////////////////////////////////////////


*use "check_WB_Gender_all_0915.dta", clear
use check_WB_Gender_all_1008, clear
kountry  iso3c, from(iso3c) to(imfn)
drop if _IMFN_ ==.
rename _IMFN_ countrycode
drop country iso2c iso3c
order countrycode year
save check_WB_Gender_cleaned, replace



////////////////////////////////////////////////////////////////////
/////*Clean the Format of ValenciaLaven Database for Crisis/////////
////////////////////////////////////////////////////////////////////

use "ValenciaLaeven.dta", clear
kountry  Country_code, from(iso3c) to(imfn)
drop if _IMFN_ ==.
rename _IMFN_ countrycode
drop Country Country_code 
order countrycode year
save ValenciaLaeven_cleaned, replace

////////////////////////////////////////////////////////////////////
/////*Start to Merge WB, genderindex, and IMF Lending Dataset///////
////////////////////////////////////////////////////////////////////
******* Revise the current data here*************
use "Kuruc IMFLending.dta", clear

kountry  Country_code, from(iso3c) to(imfn)
rename _IMFN_ countrycode

tab Country   if countrycode ==.
*drop them because no mapped data available in genderindex
drop if  countrycode ==.

local vars Amount*

egen all_non_missing = rownonmiss(`vars')
gen program = 1 if all_non_missing
drop all_non_missing
order Country  year yearend
rename program Kuruc_program
save "Kuruc IMFLending_Cleaned.dta", replace

use check_WB_Gender_cleaned, clear

*Merge with the Gender index data cleaned aboved
merge 1:1 countrycode year using genderindex.dta
drop if _m ==2
drop _m

*Merge with the WB income classification
merge 1:1 countrycode year using WB_income_class_v1.dta
drop if _m ==2
drop _m

*Merge with WB Database
merge 1:1 countrycode year using "Kuruc IMFLending_Cleaned.dta"
drop if _m ==2
drop _m


*Add the missing data on the WB income classification
merge 1:1 countrycode year using Missing_filled_WB_income_level.dta
replace income_level = income_level_filled if income_level==""
drop _m income_level_filled
sort countrycode year


*Merge with Crisis
merge 1:1 countrycode year using ValenciaLaeven_cleaned.dta
drop if _m ==2
drop _m

keep if inrange(year, 1980, 2023)

rename SE_ENR_TERT_FM_ZS Tert_Enr_GPI
rename SE_ENR_SECO_FM_ZS Sec_Enr_GPI
rename SE_ENR_PRIM_FM_ZS Prim_Enr_GPI
rename SH_STA_MMRT  Mat_Mort_R_MO
rename SP_ADO_TFRT Ad_Fert_R

*Female/Male Labor Force Participation
rename SL_TLF_CACT_FM_ZS  F_M_LFPR_RATIO
replace F_M_LFPR_RATIO = F_M_LFPR_RATIO/100

*Female Labor Force Participation
rename SL_TLF_CACT_FE_ZS  LFPR_Fem_ILO

rename FI_RES_TOTL_MO  ResMoImp
rename DT_DOD_DSTC_IR_ZS STDebtPctofRes 
renam  FI_RES_TOTL_DT_ZS ResExtDebt 
rename NE_CON_GOVT_ZS GovConsExpGDP
rename NE_IMP_GNFS_CD Imports_USD
rename FI_RES_TOTL_CD TotalRes_USD
gen MoRes_Constr = TotalRes_USD / (Imports_USD/12)

mdesc Tert_Enr_GPI Sec_Enr_GPI Prim_Enr_GPI Mat_Mort_R_MO Ad_Fert_R F_M_LFPR_RATIO LFPR_Fem_ILO ResMoImp STDebtPctofRes ResExtDebt GovConsExpGDP

save merged_paneldata, replace



*******************************COMMITMENTS Data**********************************

import excel "`path'\COMMITMENT.xlsx", sheet("COMMITMENTS_CLEAN_Theo") firstrow clear
drop if Member == "Total"

replace MemberCode = "YEM" if MemberCode == "YMN" 
replace MemberCode = "ROU" if MemberCode == "ROM" 
replace MemberCode = "UVK" if MemberCode == "KOS"  
replace MemberCode = "SRB" if MemberCode == "YFR"  

kountry MemberCode, from (iso3c) to (imfn)
rename _IMFN_ countrycode
replace countrycode = 733 if  MemberCode == "SSD" 
replace countrycode = 967 if  MemberCode == "UVK" 
gen approvalyear = year(DateOfCommitment)
rename approvalyear Programyear
save COMMITMENTS_Sorted_v1, replace

*******************************MONA Data**********************************
/*
import excel "`path'\ArchMecon.xlsx", sheet("ArchMecon") firstrow clear

rename ApprovalYear approvalyear 
replace ReviewType = "R0" if ReviewSequence == "E"
keep if  ReviewType == "R0"
rename CountryCode countrycode 
gen actualyear = substr(DurationOfAnnualArrangementF, strrpos(DurationOfAnnualArrangementF, "/") + 1, .)
replace actualyear = "" if actualyear == "NULL"
destring actualyear, replace
count if actualyear != Programyear
replace actualyear = Programyear if actualyear==.&Programyear!=.
drop YearType-Sort Description  RevisedEndDate-DurationOfAnnualArrangementT
save OldMONA_cleaned, replace


import excel "`path'\Mecon.xlsx", sheet("MonaData") firstrow clear
rename CountryCode countrycode 
gen   actualyear = Programyear
drop YearType-Sort Description  RevisedEndDate-DurationOfAnnualArrangementT
rename ApprovalYear approvalyear 
keep if  ReviewType == "R0"
destring countrycode, replace force
save NewMONA_cleaned, replace



use OldMONA_cleaned, clear
append using NewMONA_cleaned.dta
drop BoardActionDate BoardDocNo Mneumonic 
duplicates drop

save All_MONA_Merged, replace

use All_MONA_Merged, clear  //645 programs needs match
merge m:m countrycode Programyear using COMMITMENTS_Sorted.dta
*/


import excel "`path'\ArchDescription.xlsx", sheet("ArchDescription") firstrow clear
rename ApprovalYear approvalyear 
replace ReviewType ="R0" if ReviewType =="OldBoardApproval" & ReviewSequence == "E"
drop if inlist(ArrangementNumber, 207) &  ReviewType == "OldBoardApproval"
replace ReviewType ="R0" if ReviewType =="OldBoardApproval" 
keep if  ReviewType =="R0" 

rename CountryCode countrycode 
gen actualyear = substr(DurationOfAnnualArrangementF, strrpos(DurationOfAnnualArrangementF, "/") + 1, .)
replace actualyear = "" if actualyear == "NULL"
destring actualyear, replace
count if actualyear != Inipgmyr
replace actualyear = Inipgmyr if actualyear==.&Inipgmyr!=.
drop Precautionary Purchaseschedule-Sort Fycy DurationOfAnnualArrangementF-DurationOfAnnualArrangementT DocNum Facilitycode
save OldMONADesc_cleaned, replace


import excel "`path'\Description.xlsx", sheet("MonaData") firstrow clear
rename CountryCode countrycode 
destring countrycode, replace force
gen   actualyear = Inipgmyr
rename ApprovalYear approvalyear 
keep if  ReviewType == "R0"
drop RevisedEndDate-BoardActionDate Facilitycode Fycy Precautionary-Sort
save NewMONADesc_cleaned, replace

use OldMONADesc_cleaned, clear
append using NewMONADesc_cleaned.dta
rename Inipgmyr Programyear
save All_MONADesc_Merged, replace



use All_MONADesc_Merged, clear  //645 programs needs match
merge m:m countrycode Programyear using COMMITMENTS_Sorted_v1.dta




use COMMITMENTS_Sorted_v1, clear
keep countrycode Programyear
duplicates drop
save temp2_v1, replace

use All_MONADesc_Merged, clear
keep countrycode Programyear
duplicates drop
gen MONA =1
save temp, replace


*use temp2, clear
use temp2_v1, clear
merge m:m Programyear countrycode using temp.dta
kountry countrycode , from (imfn) m
sort Programyear NAMES_STD _m

*******************************************************************************************
*******************************************************************************************
*******************************************************************************************
use COMMITMENTS_Sorted_v1, clear
drop if inlist(Facility, "Rapid Credit Facility", "Rapid Financing Instrument", "Resilience and Sustainability Facility (Group A)", "Resilience and Sustainability Facility (Group B)", "Resilience and Sustainability Facility (Group C)", "Short-Term Liquidity Line", "Flexible Credit Line")
append using MONA_additional.dta
keep countrycode Programyear Facility //Type Facility
duplicates drop countrycode Programyear, force
gen program_new = 1
rename Programyear year
save  program_for_append, replace




use merged_paneldata, clear
merge m:m countrycode year  using program_for_append.dta
drop if _m==2
drop _m
gen CRISIS = 1 if Banking ==1 | Currency==1 | Debt ==1
gen UNTREATED = 1 if CRISIS == 1 & program_new ==.  //277    186
gen TREATED = 1 if CRISIS == 1 & program_new ==1  //114    66
*keep if inrange(year, 1990,2023)
save merged_paneldata_mod_0918, replace


use merged_paneldata_mod_v4_v2.dta, clear
keep countrycode year LFPR_Fem_ILO
rename LFPR_Fem_ILO LFPR_Fem_ILO_old
*keep if year>=1990
save LFPR_Fem_ILO_for_append, replace

use merged_paneldata_mod_0918, clear
merge 1:1 countrycode year using LFPR_Fem_ILO_for_append.dta
drop _m
replace LFPR_Fem_ILO = LFPR_Fem_ILO_old if year == 1990
replace STDebtPctofRes = . if STDebtPctofRes==0
drop countryname-attribute Country-Kuruc_program
kountry countrycode , from(imfn) m
drop MARKER
rename NAMES_STD Country
merge m:m countrycode year using MoRes_Full.dta
drop if _m==2
drop _m
merge m:m countrycode year using TradingEconomics_Cleaned.dta
drop if _m==2
drop _m
*replace  ResMoImp = MoRes_Fill if ResMoImp==. & MoRes_Fill!=.
gen ResMoImp_orig = ResMoImp
replace  ResMoImp = TradeEcon_MoRes if ResMoImp==. & TradeEcon_MoRes!=.
replace ResMoImp = MoRes_Constr  if ResMoImp==. & MoRes_Constr!=.
*save merged_paneldata_mod_0924, replace 
*save merged_paneldata_mod_1004, replace
kountry countrycode, from (imfn) to (iso3c)
rename _ISO3C_ iso3c
order countrycode iso3c
save merged_paneldata_mod_1008, replace

*Load GII from here: https://hdr.undp.org/data-center/documentation-and-downloads
import excel "`path'\hdr-data.xlsx", sheet("Data") firstrow

kountry countryIsoCode , from(iso3c) to (imfn)
rename _IMFN_ countrycode

destring year, replace force

rename value GII

keep countrycode year GII

save  GII_ref_reply

use merged_paneldata_mod_1008, clear
merge 1:1 countrycode year using GII_ref_reply.dta
drop _m
mdesc GII
mdesc GII if inrange(year, 1990,2019)
save  GII_ref_reply_merged_paneldata_mod_01242025, replace

/*
 sum TradeEcon_MoRes ResMoImp MoRes_Fill

    Variable |        Obs        Mean    Std. dev.       Min        Max
-------------+---------------------------------------------------------
TradeEcon_~s |      6,465    4.398593     4.47061    -.09187   79.23722
    ResMoImp |      6,183     4.36238    4.477369   .0022146   79.23722
  MoRes_Fill |      5,604    4.537266    4.563924   .0022146   79.23722



