
ssc install vioplot
/*
use "C:\Users\wb615937\Downloads\12.21 runs including GDP(4)\AggregateCrisis\Inputs\Synth_Formatted_Data_Final_direct_3MORE_updateProgs_12.18.dta", clear

merge 1:1 IMFcode year using "C:\Users\wb615937\Downloads\12.21 runs including GDP(4)\AggregateCrisis\Inputs\incl_prog_merge.dta"
drop if _m==2
drop _m
 save  "C:\Users\wb615937\Downloads\12.21 runs including GDP(4)\AggregateCrisis\Inputs\Synth_Formatted_Data_Final_direct_3MORE_updateProgs_12.18.dta", replace
*/
//////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
///////////// IMF GDP Synthetic Control Group //////////
// Event Study Style SCM using Wilthire's "Stacked" Allsynth option
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//start

local type = "Prim_Enr_GPI"
*local type = "Sec_Enr_GPI"
*local type = "Tert_Enr_GPI"
*local type = "Mat_Mort_R_MO"
*local type = "Ad_Fert_R"
*local type = "LFPR_Fem_ILO"
*local type = "F_M_LFPR_RATIO"
*local type = "GII"

clear all
*local path = "C:\Users\te\OneDrive - UW\STACKED GDP Growth Event Study v3 11.10\STACKED GDP Growth Event Study v3 Y&Res&CA&INFL\\`type'"
*local path = "C:\Users\gyanu\Desktop\Econ Research\Current Research WD\Replication V2\12.10 Stacked GDP3_Res4_CA4_Debt4\\`type'"//`type'"
*local path = "C:\Users\wb615937\Downloads\12.21 runs including GDP(4)\12.21 runs including GDP(4)\Stacked Bench 12.21\LFPR_Fem_ILO"   
local path = "R:\Reina\Replication_Gender_July13\Crisis_Only\Individual_Prim_Enr_GPI_v2_Final"

cd "`path'"

global starttime = c(current_time)
capture log close

log using `type'_GDP_Eventstudy1.log, replace

local k = 11 // number of regressors 3+4+4
local covar1 "ResMoImp" // vars that enter regression with several lags and must be specified blow in the allsynth command
*local covarx "ResMoImp_CA_GDP_Debt"
local initial = 1

save Temp_Treated_Program_Countries			, emptyok replace
save `type'_All_pvals_GDP_Eventstudy		, emptyok replace
save "`type'Event_Study_GDP_`covar1'.dta"	, emptyok replace


///////////// Compiling Crisis Data pre-1987 //////////

use "R:\Reina\Replication_Gender_July13\Crisis_Only\Inputs\crisis_VL_AT_RRT_NCW_latest_10-14.dta", clear 
*ren countrycode IMFcode
*merge m:1 IMFcode year using merged_paneldata_mod_0923_v1_longest, keepusing(program_new) keep(match master)
drop _m
merge m:1 IMFcode year using "R:\Reina\Replication_Gender_July13\Crisis_Only\Inputs\Synth_Formatted_Data_Final_direct_3MORE_updateProgs_12.18.dta", keepusing(program_new incl classification) 
drop dup_tag
tab year

gen Inflation_VL = 0
gen InflationCrisis_VL = 0
gen InflationCrisis_NCW = 0
gen DebtCrisis_RRT = 0
replace DebtCrisis_RRT = 1 if Dom_Debt_Def_RRT == 1 | Sov_Debt_Def_RRT == 1
ren InflationCrises_RRT InflationCrisis_RRT
ren CurrencyCrises_RRT CurrencyCrisis_RRT
replace gry = gry*100

***Generate new variable 'all crisis'
gen AllCrisis = (BankingCrisis_RRT == 1 | SystemicCrisis_RRT == 1 | Dom_Debt_Def_RRT == 1 | Sov_Debt_Def_RRT == 1 | CurrencyCrisis_RRT == 1 | InflationCrisis_RRT == 1 | Restructure_AT == 1 | Banking_VL == 1 | Currency_VL == 1 | Debt_VL == 1 | BankingCrisis_NCW == 1 | CurrencyCrisis_NCW == 1 | DebtCrisis_NCW == 1)

save crisis_VL_AT_RRT_NCW_latest_10-14a, replace

use crisis_VL_AT_RRT_NCW_latest_10-14a, clear

*generate dummies 
gen `type'_VL  = 0
gen `type'Crisis_NCW  = 0
gen `type'Crisis_RRT  = 0

// `type'
keep AllCrisis `type'_VL `type'Crisis_NCW `type'Crisis_RRT incl program_new InflationCrisis_RRT Infl_pct_RRT /// 
      Country_code IMFcode grOilProd `type' war_conflict year classification
	  
	  replace incl = . if incl == 2
order Country_code IMFcode year incl program_new AllCrisis `type'_VL `type'Crisis_NCW `type'Crisis_RRT

//drop if `type' ==.
drop if year < 1990
format `type' %9.1f

foreach var in program_new incl `type'_VL `type'Crisis_NCW `type'Crisis_RRT grOilProd war_conflict {
    replace `var' = 0 if missing(`var')
}

save `type'_crisis_v1, replace
//////////////////////////////////////
use `type'_crisis_v1, clear

xtset IMFcode year

/// find IMF programs:
gen IMFprog_`type' = 0
replace IMFprog_`type' = 1 if incl == 1 //& AllCrisis == 1

//replace IMFprog_`type' = 1 if program_new == 1 & (L.`type'_VL == 1 & IMFprog_`type' == 0 |              ///
//												L.`type'Crisis_NCW == 1 & IMFprog_`type' == 0 |         ///
//												L.`type'Crisis_RRT == 1 & IMFprog_`type' == 0  | ///		
//												F.`type'_VL == 1 & IMFprog_`type' == 0 |                ///
//												F.`type'Crisis_NCW == 1 & IMFprog_`type' == 0 |         ///
//												F.`type'Crisis_RRT == 1 & IMFprog_`type' == 0 )											
//tab IMFprog_`type'	
//replace IMFprog_`type' = 1 if  program_new	==1					
												
/// take out IMF programs with previous/post IMF ***`type'**** programs (+-4 yrs)
/// "what is the effect of IMF `type' programs in countries..." 
/// (notice we do NOT take out IMF programs that had previous crises [should we?]!!!)
//gen XIMFprog_`type' = IMFprog_`type' 
//replace XIMFprog_`type' = 0 if IMFprog_`type' == 1 &  																		///
//							(L.IMFprog_`type' == 1 | L2.IMFprog_`type' == 1 | L3.IMFprog_`type' == 1 | L4.IMFprog_`type' == 1) 
//replace XIMFprog_`type' = 0 if IMFprog_`type' == 1 & 																			///
//							(F.IMFprog_`type' == 1 | F2.IMFprog_`type' == 1 | F3.IMFprog_`type' == 1 | F4.IMFprog_`type' == 1)
//drop IMFprog_`type'
//ren XIMFprog_`type' IMFprog_`type'	

///////////////////
/////// now DONORS
///////////////////


///for trials
cap drop Crisis_`type'
gen Crisis_`type' = AllCrisis
replace Crisis_`type' = 0 if AllCrisis == 1 & L.AllCrisis == 1


gen leadprog = F.program_new
gen lead2prog = F2.program_new
gen lead3prog = F3.program_new
gen lead4prog = F4.program_new

gen lagprog = L.program_new
gen lag2prog = L2.program_new
gen lag3prog = L3.program_new
gen lag4prog = L4.program_new

replace Crisis_`type' = 0 if (program_new ==1| leadprog ==1| lead2prog ==1| lead3prog ==1| lead4prog ==1 | lagprog==1| lag2prog==1| lag3prog==1| lag4prog==1)

drop lag*prog lead*prog
//gen test cr = Crisis_LFPR_Fem_ILO
//replace Crisis_`type' = 0 if Crisis_`type' == 1 &  																		///
//							(L.Crisis_`type' == 1 | L2.Crisis_`type' == 1 | L3.Crisis_`type' == 1 | L4.Crisis_`type' == 1) 

//replace  Crisis_`type' = 1 if  (F.IMFprog_`type' == 1  | L.IMFprog_`type' == 1)


/// the below seems to rule out grOilProd >< 50%
*vioplot grOilProd

///Lets do graphs with and without conflict although I think at this point we can drop war
*sort war_conflict
*vioplot war_conflict

save `type'_untreated_treated, replace

////////////////////////////////////////////////////////////////////////////////
// GRAPH
////////////////////////////////////////////////////////////////////////////////
// treated
////////////////////////////////////////////////////////////////////////////////
clear all 

save treated_`type', emptyok replace

forval progyr = 1990/2022{
use `type'_untreated_treated, clear
xtset IMFcode year

keep if year == `progyr'   &   IMFprog_`type'   == 1 | ///
		year == `progyr'-1 & F.IMFprog_`type'   == 1 | ///
		year == `progyr'-2 & F2.IMFprog_`type'  == 1 | ///		
		year == `progyr'-3 & F3.IMFprog_`type'  == 1 | ///		
		year == `progyr'-4 & F4.IMFprog_`type'  == 1 | ///  		
		year == `progyr'+1 & L.IMFprog_`type'   == 1 | ///
		year == `progyr'+2 & L2.IMFprog_`type'  == 1 | ///
		year == `progyr'+3 & L3.IMFprog_`type'  == 1 | ///
		year == `progyr'+4 & L4.IMFprog_`type'  == 1 
gen event_time = year - `progyr'		
append using treated_`type'		
save treated_`type', replace
}

use treated_`type'	

sort IMFcode year
// note the turkey overlap...
egen avg_`type'_treat = mean(`type'), by(event_time)
keep event_time avg_`type'_treat
duplicates drop event_time, force
save treated_`type'_graph, replace

////////////////////////////////////////////////////////////////////////////////
// untreated
////////////////////////////////////////////////////////////////////////////////
clear all 

save untreated_`type', emptyok replace

forval progyr = 1994/2022{
use `type'_untreated_treated, clear
xtset IMFcode year

keep if year == `progyr'   &   Crisis_`type'   == 1 | ///
		year == `progyr'-1 & F.Crisis_`type'   == 1 | ///
		year == `progyr'-2 & F2.Crisis_`type'  == 1 | ///		
		year == `progyr'-3 & F3.Crisis_`type'  == 1 | ///		
		year == `progyr'-4 & F4.Crisis_`type'  == 1 | ///  		
		year == `progyr'+1 & L.Crisis_`type'   == 1 | ///
		year == `progyr'+2 & L2.Crisis_`type'  == 1 | ///
		year == `progyr'+3 & L3.Crisis_`type'  == 1 | ///
		year == `progyr'+4 & L4.Crisis_`type'  == 1 
gen event_time = year - `progyr'		
append using untreated_`type'		
save untreated_`type', replace
}

set autotabgraphs on, permanently

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// drop HICs
local datasets "treated_`type' untreated_`type'"
local output "treated_`type'_graph untreated_`type'_graph"
local varnames "avg_`type'_treat avg_`type'_untreat"
local dummyvars "IMFprog_`type' Crisis_`type'"
local counts "num_IMFprog_`type' num_Crisis_`type'"

forvalues i = 1/2 {
    use `: word `i' of `datasets'', clear
    tab classification
    drop if classification == "H"
    
    count if `: word `i' of `dummyvars'' == 1
    local `: word `i' of `counts'' = r(N)
    
    egen `: word `i' of `varnames'' = mean(`type'), by(event_time)
    keep event_time `: word `i' of `varnames''
    duplicates drop event_time, force
    save `: word `i' of `output'', replace
}

merge 1:1 event_time using treated_`type'_graph
drop _merge

tsset event_time
graph twoway (tsline avg_`type'_untreat, lcolor(black)) ///
             (tsline avg_`type'_treat, lcolor(red)),    ///
             xlabel(#9) ytitle("`type'") ///
             legend(order(1 "Untreated (`num_Crisis_`type'')" 2 "Treated (`num_IMFprog_`type'')")) ///
             title("No HICs `type'") saving(Event_No_HICS_`type', replace) scheme(sj) name(noHICs`type')
graph export "Event_No_HICS_noHICs`type'.jpg", as(jpg) name("noHICs`type'") quality(100) replace
graph close _all

/// With HICS
local datasets "treated_`type' untreated_`type'"
local output "treated_`type'_graph untreated_`type'_graph"
local varnames "avg_`type'_treat avg_`type'_untreat"
local dummyvars "IMFprog_`type' Crisis_`type'"
local counts "num_IMFprog_`type' num_Crisis_`type'"

forvalues i = 1/2 {
    use `: word `i' of `datasets'', clear
    tab classification
    *drop if classification == "H"
    
    count if `: word `i' of `dummyvars'' == 1
    local `: word `i' of `counts'' = r(N)
    
    egen `: word `i' of `varnames'' = mean(`type'), by(event_time)
    keep event_time `: word `i' of `varnames''
    duplicates drop event_time, force
    save `: word `i' of `output'', replace
}

merge 1:1 event_time using treated_`type'_graph
drop _merge

tsset event_time
graph twoway (tsline avg_`type'_untreat, lcolor(black)) ///
             (tsline avg_`type'_treat, lcolor(red)),    ///
             xlabel(#9) ytitle("`type'") ///
             legend(order(1 "Untreated (`num_Crisis_`type'')" 2 "Treated (`num_IMFprog_`type'')")) ///
             title("With HICs `type'") saving(Event_HICS_`type', replace) scheme(sj) name(HICs_`type')
graph export "Event_HICS_`type'.jpg", as(jpg) quality(100) replace		 
graph close _all

use treated_`type', clear
vioplot `type', over(event_time) title("`type' treated w/HICs `type'") name(v_treated_HICs_`type')
*graph export "GDP Growth treated w/HICs `type'.jpg", as(jpg) name("v_treated_HICs_Currency") quality(100) replace
*graph close _all

drop if classification == "H"
vioplot `type', over(event_time) title("`type' treated noHICs `type'") name(v_treated_noHICs_`type')
*graph export "GDP Growth treated noHICs `type'.jpg", as(jpg) quality(100) replace
*graph close _all

use untreated_`type', clear
vioplot `type', over(event_time) title("`type' Untreated w/HICs `type'") name(v_untreated_Hics_`type')
*graph export "GDP Growth Untreated w/HICs `type'.jpg", as(jpg) quality(100) replace
*graph close _all

drop if classification == "H"
//vioplot `type', over(event_time) title("`type' UNtreated noHICs `type'") name(v_untreated_noHICs_`type')
*graph export "GDP Growth UNtreated noHICs `type'.jpg", as(jpg) quality(100) replace
*graph close _all

// combined vioplot HIC
use treated_`type', clear
ren `type' `type'_T
save zzz, replace
use untreated_`type', clear
ren `type' `type'_UT
append using zzz
vioplot `type'_T `type'_UT, over(event_time) title("`type' (Un)Treated w/HICs `type'") name(vio_HICs_`type')
*graph export "GDP Growth (Un)Treated w/HICs `type'.jpg", as(jpg) quality(100) replace
*graph close _all

drop if classification == "H"
vioplot `type'_T `type'_UT, over(event_time) title("`type'(Un)Treated NoHICs `type'") name(vio_noHICs_`type')	
*graph export "GDP Growth (Un)Treated NoHICs `type'.jpg", as(jpg) quality(100) replace
*graph close _all		 

graph close			 
use untreated_`type', clear
save untreated_`type'_final, replace

use treated_`type', clear
save treated_`type'_final, replace

////////////////////////////////////////
// combine growth and event study data
////////////////////////////////////////

// use new, updated income classification data
*use "C:\Users\te\OneDrive - UW\STACKED GDP Growth Event Study v3 11.10\STACKED GDP Growth Event Study v3 Y&Res&CA&INFL\Synth_Formatted_Data_Final_v2b-wb_direct_3MORE_final.dta", clear
use "R:\Reina\Replication_Gender_July13\Crisis_Only\Inputs\Synth_Formatted_Data_Final_direct_3MORE_updateProgs_12.18.dta", clear

*ren IMFcode Country_code
*drop if year<1987 //dropping for consistency with crisis data
//drop _m
merge 1:1 IMFcode year using `type'_untreated_treated // has inflation crises dropped in Crisis_Type_Master_v3 file
drop if _m == 2 //Dropping Puerto Rico, Tuvalu, Kosovo, South Sudan due to data availability
ren _merge merge_`type'Crisis
*gen Crisis_`type'_all = 1 if Crisis_`type' == 1 | IMFprog_`type' == 1
save Synth_Formatted_Data_WB_direct_CrisisMerged.dta, replace

forval progyr = 1994/2022{
use Synth_Formatted_Data_WB_direct_CrisisMerged, clear
xtset IMFcode year
keep if year == `progyr'   &   IMFprog_`type'   == 1 | ///
		year == `progyr'-1 & F.IMFprog_`type'   == 1 | ///
		year == `progyr'-2 & F2.IMFprog_`type'  == 1 | ///		
		year == `progyr'-3 & F3.IMFprog_`type'  == 1 | ///		
		year == `progyr'-4 & F4.IMFprog_`type'  == 1 | ///  		
		year == `progyr'+1 & L.IMFprog_`type'   == 1 | ///
		year == `progyr'+2 & L2.IMFprog_`type'  == 1 | ///
		year == `progyr'+3 & L3.IMFprog_`type'  == 1 | ///
		year == `progyr'+4 & L4.IMFprog_`type'  == 1 | ///
		year == `progyr'   &   Crisis_`type'   == 1 | ///
		year == `progyr'-1 & F.Crisis_`type'   == 1 | ///
		year == `progyr'-2 & F2.Crisis_`type'  == 1 | ///		
		year == `progyr'-3 & F3.Crisis_`type'  == 1 | ///		
		year == `progyr'-4 & F4.Crisis_`type'  == 1 | ///  		
		year == `progyr'+1 & L.Crisis_`type'   == 1 | ///
		year == `progyr'+2 & L2.Crisis_`type'  == 1 | ///
		year == `progyr'+3 & L3.Crisis_`type'  == 1 | ///
		year == `progyr'+4 & L4.Crisis_`type'  == 1 
gen event_time = year - `progyr' + 5 // allsynth doesn't like negative #s so making treated year 5 and changing event time to 1-9 from -4 to 4
gen progyr = `progyr'
egen IMFyear = concat(IMFcode progyr)
append using "`type'Event_Study_GDP_`covar1'.dta"
save "`type'Event_Study_GDP_`covar1'.dta", replace
}
destring IMFyear, replace
drop progyr 
save "`type'Event_Study_GDP_`covar1'", replace

forval progyr = 1990/2022{
	use "`type'Event_Study_GDP_`covar1'.dta", clear
	
	tsset IMFyear event_time
	xtbalance, range(1 9) miss(`type' `covar1') 
	
	// Of these, how many had a program in progyr?
	*keep if IMFprog_`type' == 1 & event_time == 5 & classification != "H"
	keep if IMFprog_`type' == 1 & event_time == 5 	
	order countryname IMFcode classification year event_time IMFprog_`type' `dependent' `covars'
	append using Temp_Treated_Program_Countries //start with empty GE_estimate file
	save Temp_Treated_Program_Countries, replace
	}

sort countryname year
unique IMFcode year // good to check here whats going on to see sample size
duplicates drop IMFcode year, force

save "`type'Event_Study_GDP_`covar1'_Candidates_w_data.dta", replace
erase Temp_Treated_Program_Countries.dta

use "`type'Event_Study_GDP_`covar1'_Candidates_w_data.dta", clear

keep IMFyear event_time classification
save output_`type'allyrs.dta, replace

use "`type'Event_Study_GDP_`covar1'.dta", clear
merge 1:1 IMFyear event_time using output_`type'allyrs

bysort _merge: gen row = _n 
replace row = . if _merge == 1
sort row

*count if !missing(row)
*local obs_count = r(N)

save "`type'Event_Study_treated_only_GDP_`covar1'.dta" , replace

/////////////// PROGRAM START////////////////////////////////////
//////////////// take progyr and cc and classification from xls file
//////////////////////////////////////////////////////////////////

use "`type'Event_Study_treated_only_GDP_`covar1'" , clear
*sort IMFcode year

// Adding Stacked Command Dummy & Donor Dummy vars
replace IMFprog_`type' = 0 if IMFprog_`type' == .
gen StackYear = .
gen StackDummy = 0
replace StackYear=event_time if IMFprog_`type' == 1
levelsof IMFyear if IMFprog_`type' == 1, local(cod)
di "`cod'"
foreach c of local cod{
	replace StackDummy = 1 if IMFyear == `c'
}
replace StackYear=5 if StackDummy == 1
replace Crisis_`type' = . if Crisis_`type'==0

///////////////////////////////////////////////////////////////////////////////////////
*High income prog country?
// countries are classification H, L, M etc              <------------------  
// if country is H then do not drop it or any other H country 
// if country is not H, then drop all other H countries from the sample
quietly count if (classification!= "H" & event_time == 5)
local yes = r(N)
di "`yes'"
if `yes' > 0 {
  drop if classification == "H" // If there exists an observation with IMFcode == `cc' & classification != H, drop all H countries
			 }  //end if

// balance panel 
tsset IMFyear event_time
xtbalance, range(1, 9) miss(`type' `covar1') 

// associate IMFcode with ISO3 country code
kountry IMFcode, from(imfn)
tostring IMFyear, generate(IMFyear_str)

qui {
  count if !missing(row)
  local N = r(N)
  gen temp = _n if !missing(row)
  sort temp
  gen row2 = _n if !missing(row)
  drop temp
}

count if !missing(row2)
local obs_count = r(N)

save temp_for_individual_`type' , replace
************************************************************************************

 
 
save "All_pvals_`type'22allyrs_Final.dta", emptyok replace
 
/////////////// PROGRAM START////////////////////////////////////
//////////////// take progyr and cc and income_level from xls file
//////////////////////////////////////////////////////////////////

forvalues i = `initial'/`obs_count' {            

*use "C:\Users\te\OneDrive - UW\Monique gender\data_output\merged_paneldata_mod_v2_xls_added_`type'_final.dta" , clear
use "temp_for_individual_`type'.dta" , clear
*sort countrycode year
drop NAMES_STD

quiet summarize event_time in `i'
local progyr  = 5
display "program_new event_time = `progyr'"

quiet summarize IMFyear in `i'
local cc  = r(mean)
display " = `cc'"

display "obs_count = `i'"

display "Tot Nr Prog = `obs_count'"

local window = 4
local start = `progyr'-`window'
local end = `progyr'+`window'
drop if event_time > `end' | event_time < `start'

// Cannot have any other countries that had program_news from start to end
//drop if program_new == 1 & IMFyear != `cc'

///////////////////////////////////////////////////////////////////////////////////////
*High income prog country?
// countries are income_level H, L, M etc              <------------------  
// if country is H then do not drop it or any other H country 
// if country is not H, then drop all other H countries from the sample
quietly count if (IMFyear == `cc' & classification!= "H" & event_time == `progyr')
local yes = r(N)
di "`yes'"
if `yes' > 0 {
  drop if classification == "H" // If there exists an observation with countrycode == `cc' & income_level != H, drop all H countries
}

// balance panel 
tsset IMFyear event_time
xtbalance, range(`start' `end') miss(`type' `covar1') 

// associate IMFcode with ISO3 country code
kountry countrycode, from(imfn)

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Now Run Allsynth Command. (Allsynth builds on both "Synth" and "Synthrunner" and bias corrects (that is generated by imperfect match)
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
forval v=1/`window'{
	local n`v' = `progyr'-`window'-1+`v'
}

    capture noisily{ 
		allsynth `type'  `type'(`n2') `type'(`n3') `type'(`n4')  ResMoImp(`n4') ResMoImp(`n3') ResMoImp(`n2') ResMoImp(`n1'), trunit(`cc') trperiod(`progyr') unitnames(IMFyear_str) keep("`cc'_`progyr'_`type'22all_PredBal.dta") replace bcorrect(merge) pvalues 
}

 if _rc != 0 {
    continue //, break or any other action you want to take when `genvar` does not exist
}


capture use `cc'_`progyr'_`type'22all_PredBal.dta, clear
capture keep if IMFyear == `cc'
capture ren _time year  
 
*append using "C:\Users\te\OneDrive - UW\Monique gender\data_output\All_pvals_`type'_Final.dta"
capture append using "All_pvals_`type'22allyrs_Final.dta"
*save "C:\Users\te\OneDrive - UW\Monique gender\data_output\All_pvals_`type'_Final.dta", replace
save "All_pvals_`type'22allyrs_Final.dta", replace
}



/*
use "All_pvals_`type'22allyrs_Final.dta" , replace

*kountry countrycode, from(imfn)
ren NAMES_STD countryname
drop if rmspe == .
unique countrycode
order countryname countrycode year p_bc gap_bc

drop if p_bc > .1
unique countrycode

kountry countrycode, from(imfn)
order countryname countrycode year p_bc gap_bc

save "All_pvals_`type'22allyrs_Final_sig.dta", replace

// save all outcomes ready for xls file
use "All_pvals_`type'22allyrs_Final.dta" , replace


rename NAMES_STD countryname 
drop if unique_W == 0
keep countryname year _Y_treated gap_bc p_bc N unique_W
order countryname year _Y_treated gap_bc p_bc N unique_W
export excel using "`path'\Result_Summary`type'22allyrs", sheet("`type'_22all") sheetmodify firstrow(variables)
*/

capture display "Total run time: " c(current_time) - $starttime
log close	   

/*






//////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Now Run Allsynth Command. (Allsynth builds on both "Synth" and "Synthrunner" and bias corrects (that is generated by imperfect match)
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
*set trace on
capture noisily { 
allsynth `type'														///
`type'(2) `type'(3) `type'(4)										///
ResMoImp(1)	ResMoImp(2)	ResMoImp(3)	ResMoImp(4)						///
, bcorrect(merge) pvalues keep("`type'all_PredBal.dta", replace) 	///
stacked(trunits(StackDummy) trperiods(StackYear), clear balanced unique_w) pval(rmspe variance)
				}

				
				
// from Wilthires old Allsynth paper (pre Nov 10 2024 version)"
* "If the allsynth option pvalues is also specified, then the estimated average gaps, 
* placebo gaps, RMPSE, and RMSPE- ranked p-values will be saved in filename ate distn.dta. 
* In this case, the sampled placebo averages are assigned an ID number ≥ 1 in the variable 
* placeboID, while the estimated average gap (or estimated average treatment effect) 
* is assigned the placeboID value of 0."
// So: _placeboID == 0 is the STACKED AVERAGE gaps and pvalues

use "`type'all_PredBal_ate_distn.dta", replace
sort _placeboID _tm

ren _tm _time
ren gap_bc avg_gap_bc_treated

* Generate graph for avg treatment effect and all placebo runs
* Initialize an empty string to hold the plot commands for all countries except _placeboID == 0
local plots ""

* Loop through each country and add the line plot command to the string
forvalues i = 1/101 {
    local plots `plots' (line avg_gap_bc_treated _time if _placeboID == `i', lc(gs14) lwidth(thin) legend(off))
}

* Add the line plot commands for _placeboID == 0 at the end to ensure they are on top
local plots `plots' ///
    (line avg_gap_bc_treated _time if _placeboID == 0, lc(black) lwidth(thick) legend(label(1 "IMF Program Countries"))) ///
    (line LB_95_bc _time if _placeboID == 0, lc(gray) lpattern(dash) legend(off)) ///
    (line UB_95_bc _time if _placeboID == 0, lc(gray) lpattern(dash) legend(off))

* Generate the combined graph for all countries
twoway `plots', ///
    title("`type' Crisis, Event Study by Country") ///
    subtitle("Program Country - Control Group" ///
             "Controls: `covar1'") ///
xlabel(1 "-4" 2 "-3" 3 "-2" 4 "-1" 5 "E" 6 "1" 7 "2" 8 "3" 9 "4") ///
    xtitle("Event Time") ///
    ytitle("Bias-Corrected Growth Gap") ///
yscale(range(-7 5)) ///
graphregion(color(white))  
   
graph export "EventStudy_GDP&`covar1'_withPlacebos_v1.pdf"
*saving("EventStudy_GDP&`covar1'_withPlacebos", replace)

* Generate file with combined gaps to inspect if gaps are ok
clear all
save AllGapsCombined`type', emptyok replace

local filelist: dir "`path'" files "*_PredBal_IMF*"
di `filelist'
foreach f of local filelist {

use `f', clear
keep if IMFyear == trunit
append using AllGapsCombined`type'
save AllGapsCombined`type', replace
}

***************************************
// generate graph for the ATE only
/*
drop if _placeboID != 0

twoway (rarea min90_bc plus90_bc _time, color(gs14) ///
       legend(label(2 "90% CI"))) ///
       (line avg_gap_bc_treated _time, lc(black) lwidth(thick) ///
       legend(label(1 "IMF Program Countries"))) ///
       (line min90_bc _time, lc(gray) lpattern(dash)) ///
       (line plus90_bc _time, lc(gray) lpattern(dash)), ///
       title("`type' Crisis, Event Study") ///
       subtitle("Program Country - Control Group") ///
       xlabel(1 "-4" 2 "-3" 3 "-2" 4 "-1" 5 "E" 6 "1" 7 "2" 8 "3" 9 "4") ///
       xtitle("Event Time") ///
       ytitle("Bias-Corrected Growth Gap") ///
       saving(`type'_Y&Res_EventStudy, replace)	   
*/



capture display "Total run time: " c(current_time) - $starttime
log close	   
*/