


*local varlist F_M_LFPR_RATIO LFPR_Fem_ILO Ad_Fert_R Mat_Mort_R_MO GII Prim_Enr_GPI Sec_Enr_GPI Tert_Enr_GPI

local varlist  F_M_LFPR_RATIO LFPR_Fem_ILO Ad_Fert_R Mat_Mort_R_MO GII Prim_Enr_GPI Sec_Enr_GPI Tert_Enr_GPI 
*local varlist  GII
foreach var1 of local varlist {
	
	*local var F_M_LFPR_RATIO
	
// Load your data
 cap use "R:\Reina\Replication_Gender_July13\Appendix Table Results\All_pvals_`var1'22allyrs_Finalcomplete.dta" , clear

 cap use "R:\Reina\Replication_Gender_July13\Appendix Table Results\All_pvals_`var1'22allyrs_FinalALLcomplete.dta" , clear



// STEP 2: Rename variables
rename gappctsigm4 tminus4
rename gappctsigm3 tminus3
rename gappctsigm2 tminus2
rename gappctsigm1 tminus1
rename gappctsig0 tplus0
rename gappctsig1 tplus1
rename gappctsig2 tplus2
rename gappctsig3 tplus3
rename gappctsig4 tplus4

foreach var of varlist t* {
    replace `var' = subinstr(`var', "***", "", .)
    replace `var' = subinstr(`var', "**", "", .)
    replace `var' = subinstr(`var', "*", "", .)
    destring `var', replace
}

*Drop if large pretreatment fit:


drop  if tminus1>10
drop  if tminus1<-10


 destring progyr , replace force
/*
 preserve
 collapse (mean) tminus4-tplus4
 save data_summary, replace
 gen progyr = 9999
 gen countryname = "Total"

save data_summary, replace
 restore
 
 append using data_summary.dta
*/
 

*replace progyr = "year" + progyr
reshape long t, i(countryname progyr) j(year, string) 
replace countryname = subinstr(countryname, " ", "", .)

  gen number = ceil(_n / 9)


*drop if countryname =="Total"

  preserve

 bysort year: egen ave_gap = mean(t)
 gen squared = (t-ave_gap)^2
sum squared if year=="plus0"
local size = `r(N)'
 collapse (sum) square, by(year)

 gen Var_placebo = squared/`size'
 gen SE_placebo = sqrt(Var_placebo)
 gen time =.
replace time = 1 if year == "minus4"
replace time = 2 if year == "minus3"
replace time = 3 if year == "minus2"
replace time = 4 if year == "minus1"
replace time = 5 if  year == "plus0"
replace time = 6 if year == "plus1"
replace time = 7 if year == "plus2"
replace time = 8 if year == "plus3"
replace time = 9 if year == "plus4" 

replace SE_placebo = 0 if inrange(time,1,4)
 save SE_Constructed, replace
 restore
 

 
 gen time =.
replace time = 1 if year == "minus4"
replace time = 2 if year == "minus3"
replace time = 3 if year == "minus2"
replace time = 4 if year == "minus1"
replace time = 5 if  year == "plus0"
replace time = 6 if year == "plus1"
replace time = 7 if year == "plus2"
replace time = 8 if year == "plus3"
replace time = 9 if year == "plus4" 
 
gen time_label = ""
replace time_label = "t-4" if year == "minus4"
replace time_label = "t-3" if year == "minus3"
replace time_label = "t-2" if year == "minus2"
replace time_label = "t-1" if year == "minus1"
replace time_label = "t" if  year == "plus0"
replace time_label = "t+1" if year == "plus1"
replace time_label = "t+2" if year == "plus2"
replace time_label = "t+3" if year == "plus3"
replace time_label = "t+4" if year == "plus4"

 save temp1, replace
 
 
bysort time: egen mean_gap = mean(t)
*bysort time: egen mean_p = mean(p)
keep time mean_gap 
duplicates drop
rename mean_gap  t
gen progyr = 9999
gen number = 822
gen countryname = "Mean Statistics"

gen time_label = ""
replace time_label = "t-4" if time == 1
replace time_label = "t-3" if time == 2
replace time_label = "t-2" if time == 3
replace time_label = "t-1" if time == 4
replace time_label = "t" if time == 5
replace time_label = "t+1" if time == 6
replace time_label = "t+2" if time == 7
replace time_label = "t+3" if time == 8
replace time_label = "t+4" if time == 9	  
save temp2, replace

use temp1, clear
append using temp2.dta


save cleaned_Results_Merged_for_META, replace
erase temp1.dta
erase temp2.dta


	
	
grstyle init
grstyle numstyle legend_cols 1
grstyle linestyle legend none
grstyle color background white 

use cleaned_Results_Merged_for_META, clear

merge m:m time using SE_Constructed.dta 
drop _m
tsset number time
gen upper = t + 1.96*SE_placebo
gen lower = t - 1.96*SE_placebo
*keep number time gap upper lower

*local start_time = 1
*local end_time = 9
local highlight_country 822
gen avg_est = t if number ==  `highlight_country'

replace avg_est = . if number != `highlight_country'
replace lower = . if number != `highlight_country'
replace upper = . if number != `highlight_country'
keep number time t upper lower  avg_est 

* Initialize a local macro to accumulate the lines
local lines ""


* Loop over each countrycode and accumulate lines
levelsof number, local(numbers)
foreach country of local numbers {
    local linecolor
    if `country' == `highlight_country' {
        local linecolor "lcolor(black) lwidth(thick)"
    }
    else {
        local linecolor "lcolor(gs8) lwidth(thin)"
    }
    local lines "`lines' (line t time if number == `country', `linecolor')"
}

* Calculate the range of y-axis values
summarize t
*local min_y = r(min)
disp "`min_y'"
*local max_y = r(max)
disp "`max_y'"

if "`var1'" == "F_M_LFPR_RATIO"{

local lower = -40
local upper = 20
local middle = 10

}


if "`var1'" == "LFPR_Fem_ILO"{

local lower = -40
local upper = 20
local middle = 10

}



if "`var1'" == "Ad_Fert_R"{

local lower = -50
local upper = 50
local middle = 25

}


if "`var1'" == "Mat_Mort_R_MO"{

local lower = -40
local upper = 70
local middle = 10

}



if "`var1'" == "GII"{

local lower = -40
local upper = 40
local middle = 10

}

if "`var1'" == "Prim_Enr_GPI"{

local lower = -20
local upper = 20
local middle = 5

}

if "`var1'" == "Sec_Enr_GPI"{

local lower = -20
local upper = 20
local middle = 5

}
if "`var1'" == "Tert_Enr_GPI"{

local lower = -20
local upper = 20
local middle = 5

}


disp "`var'"

* Start the plot and add all accumulated lines
twoway ///
    `lines' ///
    (rarea upper lower time if number == `highlight_country', bcolor(red%10) clw(medthin medthin)) ///
    (line upper time if number == `highlight_country', lcolor(red) lpattern(dot) lwidth(medthin)) ///
    (line lower time if number == `highlight_country', lcolor(red) lpattern(dot) lwidth(medthin)) ///
    (line avg_est time if number == `highlight_country', lcolor(red) lwidth(thick)) ///
    , ylabel(`lower'(`middle')`upper') ///
    xlabel(1 "t-4" 2 "t-3" 3 "t-2" 4 "t-1" 5 "t" 6 "t+1" 7 "t+2" 8 "t+3" 9 "t+4") ///
    xline(5, lcolor(black) lpattern(dash)) ///	
    yline(0, lwidth(thick) lcolor(black)) ///
    xtitle("Year") ///
    ytitle("Normalized Gender Gap") ///
    title("`var1'") ///
    legend(off) ///
    name("`var1'", replace) 
}

erase SE_Constructed.dta
