

grstyle init
grstyle numstyle legend_cols 1
grstyle linestyle legend none
grstyle color background white 

cd "R:\Reina\Replication_Gender_July13\AllFigures"

* Load your dataset
use "243_2003_LFPR_Fem_ILO22all_PredBal.dta", clear 
drop if _time ==.


gen programx = .
order countrycode programx

replace programx = -4 if _n == 1 | (_n >= 1 & mod(_n - 1, 9) == 0)
replace programx = -3 if _n == 2 | (_n >= 2 & mod(_n - 2, 9) == 0)
replace programx = -2 if _n == 3 | (_n >= 3 & mod(_n - 3, 9) == 0)
replace programx = -1 if _n == 4 | (_n >= 4 & mod(_n - 4, 9) == 0)
replace programx =  0 if _n == 5 | (_n >= 5 & mod(_n - 5, 9) == 0)
replace programx =  1 if _n == 6 | (_n >= 6 & mod(_n - 6, 9) == 0)
replace programx =  2 if _n == 7 | (_n >= 7 & mod(_n - 7, 9) == 0)
replace programx =  3 if _n == 8 | (_n >= 8 & mod(_n - 8, 9) == 0)
replace programx =  4 if _n == 9 | (_n >= 9 & mod(_n - 9, 9) == 0)

order countrycode programx _Y_treated _Y_synthetic

* Normalize
gen Y_treat_base = _Y_treated if programx == -1
replace Y_treat_base = Y_treat_base[_n-1] if programx == 0
replace Y_treat_base = Y_treat_base[_n+1] if programx == -2
replace Y_treat_base = Y_treat_base[_n+2] if programx == -3
replace Y_treat_base = Y_treat_base[_n+3] if programx == -4
replace Y_treat_base = Y_treat_base[_n-2] if programx == 1
replace Y_treat_base = Y_treat_base[_n-3] if programx == 2
replace Y_treat_base = Y_treat_base[_n-4] if programx == 3
replace Y_treat_base = Y_treat_base[_n-5] if programx == 4

gen gap_norm = gap / Y_treat_base
gen double gapnormpct = round(gap_norm * 100, 0.01)




*replace gapnormpct = _Y_treated if countrycode ==243
keep gapnormpct _time countrycode p 
*drop if inlist(IMFcode, 672,612)

rename _time year

* Remove duplicates to ensure clean data
duplicates drop

preserve
gen time = mod(_n-1, 9) + 1
bysort time: egen ave_gap = mean(gapnormpct) if inrange(time, 1, 9)

gen pval = p if countrycode ==243
gen Z = invnorm(1 - pval / 2) if countrycode ==243
gen SE = abs(gapnormpct-ave_gap) / Z if countrycode ==243

gen squared = (gapnormpct-ave_gap)^2
sum squared if time == 5
local size = `r(N)'
collapse (sum) square (mean) gapnormpct (mean) Z (mean) SE, by(time)
gen Var_placebo = squared/`size'
gen SE_placebo = sqrt(Var_placebo)

replace time = 1999 if time == 1
replace time = 2000 if time == 2
replace time = 2001 if time == 3
replace time = 2002 if time == 4
replace time = 2003 if time == 5
replace time = 2004 if time == 6
replace time = 2005 if time == 7
replace time = 2006 if time == 8
replace time = 2007 if time == 9	  

rename time year
gen countrycode = 822
gen upper = gapnormpct + 1.645*SE
gen lower = gapnormpct - 1.645*SE

gen upper_old = gapnormpct + 1.96*SE_placebo
gen lower_old = gapnormpct - 1.96*SE_placebo

save SE_Constructed, replace
restore

append using SE_Constructed.dta 
*Afghanistan data makes no sense
*drop  if IMFcode ==813
* Define the range of years
local start_year = 1999
local end_year = 2007
local highlight_country 243

* Define filename for export
local export_filename "gap_plot.png"

* Initialize a local macro to accumulate the lines
local lines ""
*Exclude countrycode greater than abs10:
drop  if inlist(countrycode, 612)
* Loop over each IMFcode and accumulate lines
levelsof countrycode, local(countrycode)

* Create a separate line for the Jordan
local dr_line "(line gapnormpct year if countrycode == `highlight_country', lcolor(black) lwidth(thick))"

* Create the lines for the placebo countries (gray lines)
foreach country of local countrycode {
    if `country' != `highlight_country' & `country' != 822 {
        local lines "`lines' (line gapnormpct year if countrycode == `country', lcolor(gs8) lwidth(thin))"
    }
}

* Start the plot and add all accumulated lines, plus the Jordan line
twoway ///
    `dr_line' `lines' ///
    (rarea upper lower year if countrycode == 822, bcolor(red%10) clw(medthin medthin)) ///
    (line upper year if countrycode == 822, lcolor(red) lpattern(dot) lwidth(medthin)) ///
    (line lower year if countrycode == 822, lcolor(red) lpattern(dot) lwidth(medthin)) ///
    , ylabel(-50(10)50) ///
    xlabel(`start_year'(1)`end_year') ///
    xline(2003, lcolor(black) lpattern(dash)) ///
    yline(0, lcolor(black) lpattern(dot)) ///
    legend(order(1 "Dominican Republic" 2 "Placebos") ///
        label(1 "Jordan") ///
        label(2 "Placebos")) /// 
    xtitle("Year") ///
    ytitle("Non Bias Corrected Normalized Gender Gap(%)") ///
    title("Normalized Non Bias Corrected Gap Plot") 

/*
* Start the plot and add all accumulated lines, plus the Jordan line
twoway ///
    `dr_line' `lines' ///
    (rarea upper lower year if countrycode == 822, bcolor(red%10) clw(medthin medthin)) ///
    (line upper year if countrycode == 822, lcolor(red) lpattern(dot) lwidth(medthin)) ///
    (line lower year if countrycode == 822, lcolor(red) lpattern(dot) lwidth(medthin)) ///
    (line gapnormpct year if countrycode == 822, lcolor(red) lwidth(thick)) ///	
    , ylabel(-50(10)50) ///
    xlabel(`start_year'(1)`end_year') ///
    xline(2003, lcolor(black) lpattern(dash)) ///
    yline(0, lcolor(black) lpattern(dot)) ///
    legend(order(1 "Dominican Republic" 2 "Placebos") ///
        label(1 "Jordan") ///
        label(2 "Placebos")) /// 
    xtitle("Year") ///
    ytitle("Non Bias Corrected Normalized Gender Gap(%)") ///
    title("Normalized Non Bias Corrected Gap Plot") 
	
	*/
	
	erase SE_Constructed.dta
	
